function [cobj]=mkheatmap(tdata,tdataflds,celldx,clustdx);
%
% Usage: [cobj]=mkheatmap(tdata,tdataflds,celldx,clustdx);
%
% Hierarchically cluster a matrix of Cellprofiler data and make a heatmap
% showing the results. Matlab will automatically open a window for viewing 
% the heatmap. If you close the original window, and wish to see the 
% heatmap at a later time, enter view(cobj) into the command window.
%
% tdata is the normalized ('t' for transformed) PLISH data matrix. One of
% the columns must be the cell indices.
% tdataflds is the cell array with the field names of the columns. One data
% field must include the string 'Object_Number', and the correspond column
% in tdata must be the cell indices.
% celldx is a list of the rows (cells) to use for clustering
% clustdx is a vector of the data columns to use for clustering.
%
lio=1;
%
% find the column with the cell indices and save them
cellobjdx=find(~cellfun('isempty',strfind(tdataflds,'Object_Number')));
cellobjnum=tdata(:,cellobjdx);
%
% HIERARCHICALLY CLUSTER AND PLOT CLUSTERGRAM HEATMAP
size(celldx)
cobj=clustergram(tdata(celldx,clustdx),'RowLabels',cellobjnum(celldx),'ColumnLabels',tdataflds(clustdx));
%



